/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.event;

import com.hollingsworth.mother_silverfish.ModUtil;
import com.hollingsworth.mother_silverfish.entity.SpecialFallingBlock;
import com.hollingsworth.mother_silverfish.event.ITimedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class EarthquakeEvent
implements ITimedEvent {
    int ticks;
    Supplier<BlockPos> origin;
    Level world;
    List<BlockPos> posList = new ArrayList<BlockPos>();
    int counter;

    public EarthquakeEvent(Level world, Supplier<BlockPos> origin, Supplier<BlockPos> destination) {
        this.origin = origin;
        this.world = world;
        if (origin.get() == null || destination.get() == null) {
            return;
        }
        for (BlockPos vec : ModUtil.getLine(origin.get().m_123341_(), origin.get().m_123343_(), destination.get().m_123341_(), destination.get().m_123343_(), 2.0f)) {
            BlockPos adjustedPos = new BlockPos(vec.m_123341_(), origin.get().m_123342_(), vec.m_123343_());
            if (ModUtil.distanceFrom(origin.get(), adjustedPos) >= 1.5) {
                this.addPos(adjustedPos);
            }
            for (BlockPos p : BlockPos.m_121940_((BlockPos)adjustedPos.m_142390_(2).m_142385_(2), (BlockPos)adjustedPos.m_142383_(2).m_142386_(2))) {
                if (this.posList.contains(p) || !(ModUtil.distanceFrom(origin.get(), p) >= 1.5)) continue;
                this.addPos(p.m_7949_());
            }
            BlockPos blockPos = new BlockPos(vec.m_123341_(), origin.get().m_123342_(), vec.m_123343_());
            if (!(ModUtil.distanceFrom(origin.get(), blockPos) >= 1.5)) continue;
            this.addPos(new BlockPos(vec.m_123341_(), origin.get().m_123342_(), vec.m_123343_()));
        }
    }

    public void addPos(BlockPos pos) {
        if (this.world.m_8055_(pos).m_60795_() && !this.world.m_8055_(pos.m_7495_()).m_60795_() && !this.posList.contains(pos.m_7495_())) {
            this.posList.add(pos.m_7495_());
            return;
        }
        this.posList.add(pos);
    }

    @Override
    public void tick(boolean serverSide) {
        for (BlockPos p : this.posList) {
            if (this.world.m_8055_(p).m_60795_() || this.world.m_8055_(p).m_60767_().m_76336_() || !SpecialFallingBlock.canBlockBeHarvested(this.world, p)) continue;
            SpecialFallingBlock blockEntity = SpecialFallingBlock.fall(this.world, p, this.world.m_8055_(p));
            blockEntity.m_20334_(0.0, 0.6 + EarthquakeEvent.inRange(-0.1, 0.1), 0.0);
        }
        ++this.ticks;
    }

    public static double inRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    @Override
    public boolean isExpired() {
        return this.ticks >= 1;
    }
}

